// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: exporter/exporterhelper/internal/queue/meta.proto

package queue

import (
	encoding_binary "encoding/binary"
	fmt "fmt"
	io "io"
	math "math"
	math_bits "math/bits"

	proto "github.com/gogo/protobuf/proto"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// PersistentMetadata holds all persistent metadata for the queue.
// The items and bytes sizes are recorded explicitly,
// the requests size can be calculated as (write_index - read_index + len(currently_dispatched_items)).
type PersistentMetadata struct {
	// Current total items size of the queue.
	ItemsSize int64 `protobuf:"fixed64,1,opt,name=items_size,json=itemsSize,proto3" json:"items_size,omitempty"`
	// Current total bytes size of the queue.
	BytesSize int64 `protobuf:"fixed64,2,opt,name=bytes_size,json=bytesSize,proto3" json:"bytes_size,omitempty"`
	// Index of the next item to be read from the queue.
	ReadIndex uint64 `protobuf:"fixed64,3,opt,name=read_index,json=readIndex,proto3" json:"read_index,omitempty"`
	// Index where the next item will be written to the queue.
	WriteIndex uint64 `protobuf:"fixed64,4,opt,name=write_index,json=writeIndex,proto3" json:"write_index,omitempty"`
	// List of item indices currently being processed by consumers.
	CurrentlyDispatchedItems []uint64 `protobuf:"fixed64,5,rep,packed,name=currently_dispatched_items,json=currentlyDispatchedItems,proto3" json:"currently_dispatched_items,omitempty"`
}

func (m *PersistentMetadata) Reset()         { *m = PersistentMetadata{} }
func (m *PersistentMetadata) String() string { return proto.CompactTextString(m) }
func (*PersistentMetadata) ProtoMessage()    {}
func (*PersistentMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_8ad1b29fca6d4f37, []int{0}
}
func (m *PersistentMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PersistentMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PersistentMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PersistentMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PersistentMetadata.Merge(m, src)
}
func (m *PersistentMetadata) XXX_Size() int {
	return m.Size()
}
func (m *PersistentMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PersistentMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PersistentMetadata proto.InternalMessageInfo

func (m *PersistentMetadata) GetItemsSize() int64 {
	if m != nil {
		return m.ItemsSize
	}
	return 0
}

func (m *PersistentMetadata) GetBytesSize() int64 {
	if m != nil {
		return m.BytesSize
	}
	return 0
}

func (m *PersistentMetadata) GetReadIndex() uint64 {
	if m != nil {
		return m.ReadIndex
	}
	return 0
}

func (m *PersistentMetadata) GetWriteIndex() uint64 {
	if m != nil {
		return m.WriteIndex
	}
	return 0
}

func (m *PersistentMetadata) GetCurrentlyDispatchedItems() []uint64 {
	if m != nil {
		return m.CurrentlyDispatchedItems
	}
	return nil
}

func init() {
	proto.RegisterType((*PersistentMetadata)(nil), "opentelemetry.collector.exporter.exporterhelper.internal.queue.PersistentMetadata")
}

func init() {
	proto.RegisterFile("exporter/exporterhelper/internal/queue/meta.proto", fileDescriptor_8ad1b29fca6d4f37)
}

var fileDescriptor_8ad1b29fca6d4f37 = []byte{
	// 287 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x90, 0xb1, 0x4a, 0x03, 0x41,
	0x14, 0x45, 0x33, 0x46, 0x03, 0x19, 0x1b, 0xd9, 0x6a, 0x11, 0x5c, 0x83, 0x55, 0xaa, 0x59, 0xc4,
	0x56, 0x2c, 0x24, 0x4d, 0x0a, 0x41, 0x62, 0x67, 0xe1, 0x32, 0xd9, 0xbd, 0x98, 0x81, 0xc9, 0xcc,
	0xfa, 0xf6, 0x05, 0x93, 0x7c, 0x85, 0x9f, 0x65, 0x99, 0xd2, 0x52, 0x92, 0x1f, 0x91, 0x9d, 0x64,
	0x17, 0xd2, 0xd9, 0x3d, 0xce, 0xb9, 0x5c, 0x1e, 0x57, 0xde, 0x62, 0x59, 0x7a, 0x62, 0x50, 0xda,
	0x1c, 0x33, 0xd8, 0x12, 0x94, 0x1a, 0xc7, 0x20, 0xa7, 0x6d, 0xfa, 0xb1, 0xc0, 0x02, 0xe9, 0x1c,
	0xac, 0x55, 0x49, 0x9e, 0x7d, 0xf4, 0xe0, 0x4b, 0x38, 0x86, 0xc5, 0x1c, 0x4c, 0x2b, 0x95, 0x7b,
	0x6b, 0x91, 0xb3, 0x27, 0xd5, 0x34, 0xa8, 0xe3, 0x2a, 0xd5, 0x54, 0xa9, 0x50, 0x75, 0xb3, 0x11,
	0x32, 0x7a, 0x06, 0x55, 0xa6, 0x62, 0x38, 0x7e, 0x02, 0xeb, 0x42, 0xb3, 0x8e, 0xae, 0xa4, 0x34,
	0x8c, 0x79, 0x95, 0x55, 0x66, 0x8d, 0x58, 0x0c, 0xc4, 0xf0, 0x62, 0xd2, 0x0f, 0xe4, 0xc5, 0xac,
	0x51, 0xeb, 0xe9, 0x8a, 0x71, 0xd0, 0x27, 0x7b, 0x1d, 0x48, 0xa3, 0x09, 0xba, 0xc8, 0x8c, 0x2b,
	0xb0, 0x8c, 0xbb, 0x03, 0x31, 0xec, 0x4d, 0xfa, 0x35, 0x19, 0xd7, 0x20, 0xba, 0x96, 0xe7, 0x9f,
	0x64, 0x18, 0x07, 0x7f, 0x1a, 0xbc, 0x0c, 0x68, 0x1f, 0xb8, 0x97, 0x97, 0xf9, 0x82, 0x08, 0x8e,
	0xed, 0x2a, 0x2b, 0x4c, 0x55, 0x6a, 0xce, 0x67, 0x28, 0xb2, 0xf0, 0x40, 0x7c, 0x36, 0xe8, 0x0e,
	0x7b, 0x93, 0xb8, 0x4d, 0x8c, 0xda, 0xc0, 0xb8, 0xf6, 0x8f, 0x6f, 0xdf, 0xdb, 0x44, 0x6c, 0xb6,
	0x89, 0xf8, 0xdd, 0x26, 0xe2, 0x6b, 0x97, 0x74, 0x36, 0xbb, 0xa4, 0xf3, 0xb3, 0x4b, 0x3a, 0xaf,
	0xa3, 0x77, 0xaf, 0x8e, 0xf7, 0x32, 0x3e, 0x6d, 0x27, 0x4b, 0xff, 0xb7, 0xfe, 0xb4, 0x17, 0x96,
	0xbf, 0xfb, 0x0b, 0x00, 0x00, 0xff, 0xff, 0x15, 0x90, 0x67, 0x5e, 0xae, 0x01, 0x00, 0x00,
}

func (m *PersistentMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PersistentMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PersistentMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CurrentlyDispatchedItems) > 0 {
		for iNdEx := len(m.CurrentlyDispatchedItems) - 1; iNdEx >= 0; iNdEx-- {
			i -= 8
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.CurrentlyDispatchedItems[iNdEx]))
		}
		i = encodeVarintMeta(dAtA, i, uint64(len(m.CurrentlyDispatchedItems)*8))
		i--
		dAtA[i] = 0x2a
	}
	if m.WriteIndex != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.WriteIndex))
		i--
		dAtA[i] = 0x21
	}
	if m.ReadIndex != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ReadIndex))
		i--
		dAtA[i] = 0x19
	}
	if m.BytesSize != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.BytesSize))
		i--
		dAtA[i] = 0x11
	}
	if m.ItemsSize != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(m.ItemsSize))
		i--
		dAtA[i] = 0x9
	}
	return len(dAtA) - i, nil
}

func encodeVarintMeta(dAtA []byte, offset int, v uint64) int {
	offset -= sovMeta(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PersistentMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ItemsSize != 0 {
		n += 9
	}
	if m.BytesSize != 0 {
		n += 9
	}
	if m.ReadIndex != 0 {
		n += 9
	}
	if m.WriteIndex != 0 {
		n += 9
	}
	if len(m.CurrentlyDispatchedItems) > 0 {
		n += 1 + sovMeta(uint64(len(m.CurrentlyDispatchedItems)*8)) + len(m.CurrentlyDispatchedItems)*8
	}
	return n
}

func sovMeta(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMeta(x uint64) (n int) {
	return sovMeta(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *PersistentMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMeta
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PersistentMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PersistentMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ItemsSize", wireType)
			}
			m.ItemsSize = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ItemsSize = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesSize", wireType)
			}
			m.BytesSize = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.BytesSize = int64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadIndex", wireType)
			}
			m.ReadIndex = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.ReadIndex = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteIndex", wireType)
			}
			m.WriteIndex = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			m.WriteIndex = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
		case 5:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				m.CurrentlyDispatchedItems = append(m.CurrentlyDispatchedItems, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMeta
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthMeta
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthMeta
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				elementCount = packedLen / 8
				if elementCount != 0 && len(m.CurrentlyDispatchedItems) == 0 {
					m.CurrentlyDispatchedItems = make([]uint64, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					m.CurrentlyDispatchedItems = append(m.CurrentlyDispatchedItems, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentlyDispatchedItems", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMeta(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthMeta
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMeta(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMeta
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMeta
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMeta
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMeta
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMeta
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMeta
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMeta        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMeta          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMeta = fmt.Errorf("proto: unexpected end of group")
)
