// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExponentialHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExponentialHistogram()
				CopyExponentialHistogram(dest, src)
				assert.Equal(t, src, dest)
				CopyExponentialHistogram(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExponentialHistogramSlice(t *testing.T) {
	src := []ExponentialHistogram{}
	dest := []ExponentialHistogram{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramSlice(dest, src)
	assert.Equal(t, []ExponentialHistogram{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramSlice()
	dest = CopyExponentialHistogramSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramSlice(dest, []ExponentialHistogram{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramSlice(), dest)
}

func TestCopyExponentialHistogramPtrSlice(t *testing.T) {
	src := []*ExponentialHistogram{}
	dest := []*ExponentialHistogram{}
	// Test CopyTo empty
	dest = CopyExponentialHistogramPtrSlice(dest, src)
	assert.Equal(t, []*ExponentialHistogram{}, dest)

	// Test CopyTo larger slice
	src = GenTestExponentialHistogramPtrSlice()
	dest = CopyExponentialHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExponentialHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExponentialHistogramPtrSlice(dest, []*ExponentialHistogram{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExponentialHistogramPtrSlice(dest, src)
	assert.Equal(t, GenTestExponentialHistogramPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogramUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExponentialHistogram()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExponentialHistogram(), dest)
}

func TestMarshalAndUnmarshalJSONExponentialHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExponentialHistogram()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExponentialHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExponentialHistogram() {
		t.Run(name, func(t *testing.T) {
			dest := NewExponentialHistogram()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExponentialHistogramUnknown(t *testing.T) {
	dest := NewExponentialHistogram()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExponentialHistogram(), dest)
}

func TestMarshalAndUnmarshalProtoExponentialHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogram() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExponentialHistogram()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExponentialHistogram(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExponentialHistogram(t *testing.T) {
	for name, src := range genTestEncodingValuesExponentialHistogram() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.ExponentialHistogram{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExponentialHistogram()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExponentialHistogram() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"DataPoints/wrong_wire_type":             {0xc},
		"DataPoints/missing_value":               {0xa},
		"AggregationTemporality/wrong_wire_type": {0x14},
		"AggregationTemporality/missing_value":   {0x10},
	}
}

func genTestEncodingValuesExponentialHistogram() map[string]*ExponentialHistogram {
	return map[string]*ExponentialHistogram{
		"empty":                       NewExponentialHistogram(),
		"DataPoints/test":             {DataPoints: []*ExponentialHistogramDataPoint{{}, GenTestExponentialHistogramDataPoint()}},
		"AggregationTemporality/test": {AggregationTemporality: AggregationTemporality(13)},
	}
}
