// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyKeyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewKeyValue()
				CopyKeyValue(dest, src)
				assert.Equal(t, src, dest)
				CopyKeyValue(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyKeyValueSlice(t *testing.T) {
	src := []KeyValue{}
	dest := []KeyValue{}
	// Test CopyTo empty
	dest = CopyKeyValueSlice(dest, src)
	assert.Equal(t, []KeyValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValueSlice()
	dest = CopyKeyValueSlice(dest, src)
	assert.Equal(t, GenTestKeyValueSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValueSlice(dest, src)
	assert.Equal(t, GenTestKeyValueSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValueSlice(dest, []KeyValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValueSlice(dest, src)
	assert.Equal(t, GenTestKeyValueSlice(), dest)
}

func TestCopyKeyValuePtrSlice(t *testing.T) {
	src := []*KeyValue{}
	dest := []*KeyValue{}
	// Test CopyTo empty
	dest = CopyKeyValuePtrSlice(dest, src)
	assert.Equal(t, []*KeyValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestKeyValuePtrSlice()
	dest = CopyKeyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValuePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyKeyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValuePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyKeyValuePtrSlice(dest, []*KeyValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyKeyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestKeyValuePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewKeyValue()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewKeyValue(), dest)
}

func TestMarshalAndUnmarshalJSONKeyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewKeyValue()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteKeyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoKeyValueFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesKeyValue() {
		t.Run(name, func(t *testing.T) {
			dest := NewKeyValue()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoKeyValueUnknown(t *testing.T) {
	dest := NewKeyValue()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewKeyValue(), dest)
}

func TestMarshalAndUnmarshalProtoKeyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewKeyValue()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteKeyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufKeyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesKeyValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.KeyValue{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewKeyValue()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesKeyValue() map[string][]byte {
	return map[string][]byte{
		"invalid_field":         {0x02},
		"Key/wrong_wire_type":   {0xc},
		"Key/missing_value":     {0xa},
		"Value/wrong_wire_type": {0x14},
		"Value/missing_value":   {0x12},
	}
}

func genTestEncodingValuesKeyValue() map[string]*KeyValue {
	return map[string]*KeyValue{
		"empty":      NewKeyValue(),
		"Key/test":   {Key: "test_key"},
		"Value/test": {Value: *GenTestAnyValue()},
	}
}
