// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLocation(t *testing.T) {
	for name, src := range genTestEncodingValuesLocation() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLocation()
				CopyLocation(dest, src)
				assert.Equal(t, src, dest)
				CopyLocation(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLocationSlice(t *testing.T) {
	src := []Location{}
	dest := []Location{}
	// Test CopyTo empty
	dest = CopyLocationSlice(dest, src)
	assert.Equal(t, []Location{}, dest)

	// Test CopyTo larger slice
	src = GenTestLocationSlice()
	dest = CopyLocationSlice(dest, src)
	assert.Equal(t, GenTestLocationSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLocationSlice(dest, src)
	assert.Equal(t, GenTestLocationSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLocationSlice(dest, []Location{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLocationSlice(dest, src)
	assert.Equal(t, GenTestLocationSlice(), dest)
}

func TestCopyLocationPtrSlice(t *testing.T) {
	src := []*Location{}
	dest := []*Location{}
	// Test CopyTo empty
	dest = CopyLocationPtrSlice(dest, src)
	assert.Equal(t, []*Location{}, dest)

	// Test CopyTo larger slice
	src = GenTestLocationPtrSlice()
	dest = CopyLocationPtrSlice(dest, src)
	assert.Equal(t, GenTestLocationPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLocationPtrSlice(dest, src)
	assert.Equal(t, GenTestLocationPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLocationPtrSlice(dest, []*Location{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLocationPtrSlice(dest, src)
	assert.Equal(t, GenTestLocationPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLocationUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLocation()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLocation(), dest)
}

func TestMarshalAndUnmarshalJSONLocation(t *testing.T) {
	for name, src := range genTestEncodingValuesLocation() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLocation()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLocation(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLocationFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLocation() {
		t.Run(name, func(t *testing.T) {
			dest := NewLocation()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLocationUnknown(t *testing.T) {
	dest := NewLocation()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLocation(), dest)
}

func TestMarshalAndUnmarshalProtoLocation(t *testing.T) {
	for name, src := range genTestEncodingValuesLocation() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLocation()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLocation(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLocation(t *testing.T) {
	for name, src := range genTestEncodingValuesLocation() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Location{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLocation()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLocation() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                    {0x02},
		"MappingIndex/wrong_wire_type":     {0xc},
		"MappingIndex/missing_value":       {0x8},
		"Address/wrong_wire_type":          {0x14},
		"Address/missing_value":            {0x10},
		"Line/wrong_wire_type":             {0x1c},
		"Line/missing_value":               {0x1a},
		"AttributeIndices/wrong_wire_type": {0x24},
		"AttributeIndices/missing_value":   {0x22},
	}
}

func genTestEncodingValuesLocation() map[string]*Location {
	return map[string]*Location{
		"empty":                 NewLocation(),
		"MappingIndex/test":     {MappingIndex: int32(13)},
		"Address/test":          {Address: uint64(13)},
		"Line/test":             {Line: []*Line{{}, GenTestLine()}},
		"AttributeIndices/test": {AttributeIndices: []int32{int32(0), int32(13)}},
	}
}
