// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySpanContext(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSpanContext()
				CopySpanContext(dest, src)
				assert.Equal(t, src, dest)
				CopySpanContext(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySpanContextSlice(t *testing.T) {
	src := []SpanContext{}
	dest := []SpanContext{}
	// Test CopyTo empty
	dest = CopySpanContextSlice(dest, src)
	assert.Equal(t, []SpanContext{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanContextSlice()
	dest = CopySpanContextSlice(dest, src)
	assert.Equal(t, GenTestSpanContextSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanContextSlice(dest, src)
	assert.Equal(t, GenTestSpanContextSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanContextSlice(dest, []SpanContext{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanContextSlice(dest, src)
	assert.Equal(t, GenTestSpanContextSlice(), dest)
}

func TestCopySpanContextPtrSlice(t *testing.T) {
	src := []*SpanContext{}
	dest := []*SpanContext{}
	// Test CopyTo empty
	dest = CopySpanContextPtrSlice(dest, src)
	assert.Equal(t, []*SpanContext{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanContextPtrSlice()
	dest = CopySpanContextPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanContextPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanContextPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanContextPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanContextPtrSlice(dest, []*SpanContext{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanContextPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanContextPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSpanContextUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSpanContext()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSpanContext(), dest)
}

func TestMarshalAndUnmarshalJSONSpanContext(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSpanContext()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSpanContext(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSpanContextFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSpanContext() {
		t.Run(name, func(t *testing.T) {
			dest := NewSpanContext()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSpanContextUnknown(t *testing.T) {
	dest := NewSpanContext()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSpanContext(), dest)
}

func TestMarshalAndUnmarshalProtoSpanContext(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanContext() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSpanContext()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSpanContext(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSpanContext(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanContext() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSpanContext()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSpanContext() map[string][]byte {
	return map[string][]byte{
		"invalid_field":              {0x02},
		"TraceID/wrong_wire_type":    {0xc},
		"TraceID/missing_value":      {0xa},
		"SpanID/wrong_wire_type":     {0x14},
		"SpanID/missing_value":       {0x12},
		"TraceFlags/wrong_wire_type": {0x1c},
		"TraceFlags/missing_value":   {0x1d},
		"TraceState/wrong_wire_type": {0x24},
		"TraceState/missing_value":   {0x22},
		"Remote/wrong_wire_type":     {0x2c},
		"Remote/missing_value":       {0x28},
	}
}

func genTestEncodingValuesSpanContext() map[string]*SpanContext {
	return map[string]*SpanContext{
		"empty":           NewSpanContext(),
		"TraceID/test":    {TraceID: *GenTestTraceID()},
		"SpanID/test":     {SpanID: *GenTestSpanID()},
		"TraceFlags/test": {TraceFlags: uint32(13)},
		"TraceState/test": {TraceState: "test_tracestate"},
		"Remote/test":     {Remote: true},
	}
}
