// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySpanLink(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSpanLink()
				CopySpanLink(dest, src)
				assert.Equal(t, src, dest)
				CopySpanLink(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySpanLinkSlice(t *testing.T) {
	src := []SpanLink{}
	dest := []SpanLink{}
	// Test CopyTo empty
	dest = CopySpanLinkSlice(dest, src)
	assert.Equal(t, []SpanLink{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanLinkSlice()
	dest = CopySpanLinkSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanLinkSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanLinkSlice(dest, []SpanLink{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanLinkSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkSlice(), dest)
}

func TestCopySpanLinkPtrSlice(t *testing.T) {
	src := []*SpanLink{}
	dest := []*SpanLink{}
	// Test CopyTo empty
	dest = CopySpanLinkPtrSlice(dest, src)
	assert.Equal(t, []*SpanLink{}, dest)

	// Test CopyTo larger slice
	src = GenTestSpanLinkPtrSlice()
	dest = CopySpanLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySpanLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySpanLinkPtrSlice(dest, []*SpanLink{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySpanLinkPtrSlice(dest, src)
	assert.Equal(t, GenTestSpanLinkPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSpanLinkUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSpanLink()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSpanLink(), dest)
}

func TestMarshalAndUnmarshalJSONSpanLink(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSpanLink()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSpanLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSpanLinkFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSpanLink() {
		t.Run(name, func(t *testing.T) {
			dest := NewSpanLink()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSpanLinkUnknown(t *testing.T) {
	dest := NewSpanLink()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSpanLink(), dest)
}

func TestMarshalAndUnmarshalProtoSpanLink(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanLink() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSpanLink()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSpanLink(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSpanLink(t *testing.T) {
	for name, src := range genTestEncodingValuesSpanLink() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.Span_Link{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSpanLink()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSpanLink() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                          {0x02},
		"TraceId/wrong_wire_type":                {0xc},
		"TraceId/missing_value":                  {0xa},
		"SpanId/wrong_wire_type":                 {0x14},
		"SpanId/missing_value":                   {0x12},
		"TraceState/wrong_wire_type":             {0x1c},
		"TraceState/missing_value":               {0x1a},
		"Attributes/wrong_wire_type":             {0x24},
		"Attributes/missing_value":               {0x22},
		"DroppedAttributesCount/wrong_wire_type": {0x2c},
		"DroppedAttributesCount/missing_value":   {0x28},
		"Flags/wrong_wire_type":                  {0x34},
		"Flags/missing_value":                    {0x35},
	}
}

func genTestEncodingValuesSpanLink() map[string]*SpanLink {
	return map[string]*SpanLink{
		"empty":                       NewSpanLink(),
		"TraceId/test":                {TraceId: *GenTestTraceID()},
		"SpanId/test":                 {SpanId: *GenTestSpanID()},
		"TraceState/test":             {TraceState: "test_tracestate"},
		"Attributes/test":             {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"DroppedAttributesCount/test": {DroppedAttributesCount: uint32(13)},
		"Flags/test":                  {Flags: uint32(13)},
	}
}
