// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSummaryDataPoint()
				CopySummaryDataPoint(dest, src)
				assert.Equal(t, src, dest)
				CopySummaryDataPoint(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySummaryDataPointSlice(t *testing.T) {
	src := []SummaryDataPoint{}
	dest := []SummaryDataPoint{}
	// Test CopyTo empty
	dest = CopySummaryDataPointSlice(dest, src)
	assert.Equal(t, []SummaryDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummaryDataPointSlice()
	dest = CopySummaryDataPointSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummaryDataPointSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummaryDataPointSlice(dest, []SummaryDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummaryDataPointSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointSlice(), dest)
}

func TestCopySummaryDataPointPtrSlice(t *testing.T) {
	src := []*SummaryDataPoint{}
	dest := []*SummaryDataPoint{}
	// Test CopyTo empty
	dest = CopySummaryDataPointPtrSlice(dest, src)
	assert.Equal(t, []*SummaryDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummaryDataPointPtrSlice()
	dest = CopySummaryDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummaryDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummaryDataPointPtrSlice(dest, []*SummaryDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummaryDataPointPtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSummaryDataPointUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSummaryDataPoint()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSummaryDataPoint(), dest)
}

func TestMarshalAndUnmarshalJSONSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSummaryDataPoint()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSummaryDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSummaryDataPointFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			dest := NewSummaryDataPoint()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSummaryDataPointUnknown(t *testing.T) {
	dest := NewSummaryDataPoint()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSummaryDataPoint(), dest)
}

func TestMarshalAndUnmarshalProtoSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSummaryDataPoint()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSummaryDataPoint(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSummaryDataPoint(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPoint() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.SummaryDataPoint{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSummaryDataPoint()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSummaryDataPoint() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                     {0x02},
		"Attributes/wrong_wire_type":        {0x3c},
		"Attributes/missing_value":          {0x3a},
		"StartTimeUnixNano/wrong_wire_type": {0x14},
		"StartTimeUnixNano/missing_value":   {0x11},
		"TimeUnixNano/wrong_wire_type":      {0x1c},
		"TimeUnixNano/missing_value":        {0x19},
		"Count/wrong_wire_type":             {0x24},
		"Count/missing_value":               {0x21},
		"Sum/wrong_wire_type":               {0x2c},
		"Sum/missing_value":                 {0x29},
		"QuantileValues/wrong_wire_type":    {0x34},
		"QuantileValues/missing_value":      {0x32},
		"Flags/wrong_wire_type":             {0x44},
		"Flags/missing_value":               {0x40},
	}
}

func genTestEncodingValuesSummaryDataPoint() map[string]*SummaryDataPoint {
	return map[string]*SummaryDataPoint{
		"empty":                  NewSummaryDataPoint(),
		"Attributes/test":        {Attributes: []KeyValue{{}, *GenTestKeyValue()}},
		"StartTimeUnixNano/test": {StartTimeUnixNano: uint64(13)},
		"TimeUnixNano/test":      {TimeUnixNano: uint64(13)},
		"Count/test":             {Count: uint64(13)},
		"Sum/test":               {Sum: float64(3.1415926)},
		"QuantileValues/test":    {QuantileValues: []*SummaryDataPointValueAtQuantile{{}, GenTestSummaryDataPointValueAtQuantile()}},
		"Flags/test":             {Flags: uint32(13)},
	}
}
