// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlptrace "go.opentelemetry.io/proto/slim/otlp/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyTracesData(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewTracesData()
				CopyTracesData(dest, src)
				assert.Equal(t, src, dest)
				CopyTracesData(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyTracesDataSlice(t *testing.T) {
	src := []TracesData{}
	dest := []TracesData{}
	// Test CopyTo empty
	dest = CopyTracesDataSlice(dest, src)
	assert.Equal(t, []TracesData{}, dest)

	// Test CopyTo larger slice
	src = GenTestTracesDataSlice()
	dest = CopyTracesDataSlice(dest, src)
	assert.Equal(t, GenTestTracesDataSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTracesDataSlice(dest, src)
	assert.Equal(t, GenTestTracesDataSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTracesDataSlice(dest, []TracesData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTracesDataSlice(dest, src)
	assert.Equal(t, GenTestTracesDataSlice(), dest)
}

func TestCopyTracesDataPtrSlice(t *testing.T) {
	src := []*TracesData{}
	dest := []*TracesData{}
	// Test CopyTo empty
	dest = CopyTracesDataPtrSlice(dest, src)
	assert.Equal(t, []*TracesData{}, dest)

	// Test CopyTo larger slice
	src = GenTestTracesDataPtrSlice()
	dest = CopyTracesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesDataPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyTracesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesDataPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyTracesDataPtrSlice(dest, []*TracesData{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyTracesDataPtrSlice(dest, src)
	assert.Equal(t, GenTestTracesDataPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONTracesDataUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewTracesData()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewTracesData(), dest)
}

func TestMarshalAndUnmarshalJSONTracesData(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewTracesData()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteTracesData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoTracesDataFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesTracesData() {
		t.Run(name, func(t *testing.T) {
			dest := NewTracesData()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoTracesDataUnknown(t *testing.T) {
	dest := NewTracesData()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewTracesData(), dest)
}

func TestMarshalAndUnmarshalProtoTracesData(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesData() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewTracesData()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteTracesData(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufTracesData(t *testing.T) {
	for name, src := range genTestEncodingValuesTracesData() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlptrace.TracesData{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewTracesData()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesTracesData() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"ResourceSpans/wrong_wire_type": {0xc},
		"ResourceSpans/missing_value":   {0xa},
	}
}

func genTestEncodingValuesTracesData() map[string]*TracesData {
	return map[string]*TracesData{
		"empty":              NewTracesData(),
		"ResourceSpans/test": {ResourceSpans: []*ResourceSpans{{}, GenTestResourceSpans()}},
	}
}
