// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type TracesRequest struct {
	RequestContext *RequestContext
	TracesData     TracesData
	FormatVersion  uint32
}

var (
	protoPoolTracesRequest = sync.Pool{
		New: func() any {
			return &TracesRequest{}
		},
	}
)

func NewTracesRequest() *TracesRequest {
	if !UseProtoPooling.IsEnabled() {
		return &TracesRequest{}
	}
	return protoPoolTracesRequest.Get().(*TracesRequest)
}

func DeleteTracesRequest(orig *TracesRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteRequestContext(orig.RequestContext, true)
	DeleteTracesData(&orig.TracesData, false)

	orig.Reset()
	if nullable {
		protoPoolTracesRequest.Put(orig)
	}
}

func CopyTracesRequest(dest, src *TracesRequest) *TracesRequest {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewTracesRequest()
	}
	dest.RequestContext = CopyRequestContext(dest.RequestContext, src.RequestContext)

	CopyTracesData(&dest.TracesData, &src.TracesData)

	dest.FormatVersion = src.FormatVersion

	return dest
}

func CopyTracesRequestSlice(dest, src []TracesRequest) []TracesRequest {
	var newDest []TracesRequest
	if cap(dest) < len(src) {
		newDest = make([]TracesRequest, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTracesRequest(&dest[i], false)
		}
	}
	for i := range src {
		CopyTracesRequest(&newDest[i], &src[i])
	}
	return newDest
}

func CopyTracesRequestPtrSlice(dest, src []*TracesRequest) []*TracesRequest {
	var newDest []*TracesRequest
	if cap(dest) < len(src) {
		newDest = make([]*TracesRequest, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTracesRequest()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteTracesRequest(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewTracesRequest()
		}
	}
	for i := range src {
		CopyTracesRequest(newDest[i], src[i])
	}
	return newDest
}

func (orig *TracesRequest) Reset() {
	*orig = TracesRequest{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *TracesRequest) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RequestContext != nil {
		dest.WriteObjectField("requestContext")
		orig.RequestContext.MarshalJSON(dest)
	}
	dest.WriteObjectField("tracesData")
	orig.TracesData.MarshalJSON(dest)
	if orig.FormatVersion != uint32(0) {
		dest.WriteObjectField("formatVersion")
		dest.WriteUint32(orig.FormatVersion)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *TracesRequest) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "requestContext", "request_context":
			orig.RequestContext = NewRequestContext()
			orig.RequestContext.UnmarshalJSON(iter)
		case "tracesData", "traces_data":

			orig.TracesData.UnmarshalJSON(iter)
		case "formatVersion", "format_version":
			orig.FormatVersion = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *TracesRequest) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.TracesData.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.FormatVersion != 0 {
		n += 5
	}
	return n
}

func (orig *TracesRequest) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = orig.TracesData.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x1a

	if orig.FormatVersion != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.FormatVersion))
		pos--
		buf[pos] = 0xd
	}
	return len(buf) - pos
}

func (orig *TracesRequest) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestContext", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			orig.RequestContext = NewRequestContext()
			err = orig.RequestContext.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TracesData", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TracesData.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 1:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.FormatVersion = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestTracesRequest() *TracesRequest {
	orig := NewTracesRequest()
	orig.RequestContext = GenTestRequestContext()
	orig.TracesData = *GenTestTracesData()
	orig.FormatVersion = uint32(13)
	return orig
}

func GenTestTracesRequestPtrSlice() []*TracesRequest {
	orig := make([]*TracesRequest, 5)
	orig[0] = NewTracesRequest()
	orig[1] = GenTestTracesRequest()
	orig[2] = NewTracesRequest()
	orig[3] = GenTestTracesRequest()
	orig[4] = NewTracesRequest()
	return orig
}

func GenTestTracesRequestSlice() []TracesRequest {
	orig := make([]TracesRequest, 5)
	orig[1] = *GenTestTracesRequest()
	orig[3] = *GenTestTracesRequest()
	return orig
}
