// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestProfile_MoveTo(t *testing.T) {
	ms := generateTestProfile()
	dest := NewProfile()
	ms.MoveTo(dest)
	assert.Equal(t, NewProfile(), ms)
	assert.Equal(t, generateTestProfile(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestProfile(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newProfile(internal.NewProfile(), sharedState)) })
	assert.Panics(t, func() { newProfile(internal.NewProfile(), sharedState).MoveTo(dest) })
}

func TestProfile_CopyTo(t *testing.T) {
	ms := NewProfile()
	orig := NewProfile()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestProfile()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newProfile(internal.NewProfile(), sharedState)) })
}

func TestProfile_SampleType(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, NewValueType(), ms.SampleType())
	ms.orig.SampleType = *internal.GenTestValueType()
	assert.Equal(t, generateTestValueType(), ms.SampleType())
}

func TestProfile_Sample(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, NewSampleSlice(), ms.Sample())
	ms.orig.Sample = internal.GenTestSamplePtrSlice()
	assert.Equal(t, generateTestSampleSlice(), ms.Sample())
}

func TestProfile_Time(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, pcommon.Timestamp(0), ms.Time())
	testValTime := pcommon.Timestamp(1234567890)
	ms.SetTime(testValTime)
	assert.Equal(t, testValTime, ms.Time())
}

func TestProfile_Duration(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, pcommon.Timestamp(0), ms.Duration())
	testValDuration := pcommon.Timestamp(1234567890)
	ms.SetDuration(testValDuration)
	assert.Equal(t, testValDuration, ms.Duration())
}

func TestProfile_PeriodType(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, NewValueType(), ms.PeriodType())
	ms.orig.PeriodType = *internal.GenTestValueType()
	assert.Equal(t, generateTestValueType(), ms.PeriodType())
}

func TestProfile_Period(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, int64(0), ms.Period())
	ms.SetPeriod(int64(13))
	assert.Equal(t, int64(13), ms.Period())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newProfile(internal.NewProfile(), sharedState).SetPeriod(int64(13)) })
}

func TestProfile_CommentStrindices(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.CommentStrindices())
	ms.orig.CommentStrindices = internal.GenTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenTestInt32SliceWrapper()), ms.CommentStrindices())
}

func TestProfile_ProfileID(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, ProfileID(internal.ProfileID([16]byte{})), ms.ProfileID())
	testValProfileID := ProfileID(internal.ProfileID([16]byte{1, 2, 3, 4, 5, 6, 7, 8, 8, 7, 6, 5, 4, 3, 2, 1}))
	ms.SetProfileID(testValProfileID)
	assert.Equal(t, testValProfileID, ms.ProfileID())
}

func TestProfile_DroppedAttributesCount(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(13))
	assert.Equal(t, uint32(13), ms.DroppedAttributesCount())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newProfile(internal.NewProfile(), sharedState).SetDroppedAttributesCount(uint32(13)) })
}

func TestProfile_OriginalPayloadFormat(t *testing.T) {
	ms := NewProfile()
	assert.Empty(t, ms.OriginalPayloadFormat())
	ms.SetOriginalPayloadFormat("test_originalpayloadformat")
	assert.Equal(t, "test_originalpayloadformat", ms.OriginalPayloadFormat())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newProfile(internal.NewProfile(), sharedState).SetOriginalPayloadFormat("test_originalpayloadformat")
	})
}

func TestProfile_OriginalPayload(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, pcommon.NewByteSlice(), ms.OriginalPayload())
	ms.orig.OriginalPayload = internal.GenTestByteSlice()
	assert.Equal(t, pcommon.ByteSlice(internal.GenTestByteSliceWrapper()), ms.OriginalPayload())
}

func TestProfile_AttributeIndices(t *testing.T) {
	ms := NewProfile()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.AttributeIndices())
	ms.orig.AttributeIndices = internal.GenTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenTestInt32SliceWrapper()), ms.AttributeIndices())
}

func generateTestProfile() Profile {
	return newProfile(internal.GenTestProfile(), internal.NewState())
}
