// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestScopeProfiles_MoveTo(t *testing.T) {
	ms := generateTestScopeProfiles()
	dest := NewScopeProfiles()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeProfiles(), ms)
	assert.Equal(t, generateTestScopeProfiles(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestScopeProfiles(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newScopeProfiles(internal.NewScopeProfiles(), sharedState)) })
	assert.Panics(t, func() { newScopeProfiles(internal.NewScopeProfiles(), sharedState).MoveTo(dest) })
}

func TestScopeProfiles_CopyTo(t *testing.T) {
	ms := NewScopeProfiles()
	orig := NewScopeProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestScopeProfiles()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newScopeProfiles(internal.NewScopeProfiles(), sharedState)) })
}

func TestScopeProfiles_Scope(t *testing.T) {
	ms := NewScopeProfiles()
	assert.Equal(t, pcommon.NewInstrumentationScope(), ms.Scope())
	ms.orig.Scope = *internal.GenTestInstrumentationScope()
	assert.Equal(t, pcommon.InstrumentationScope(internal.GenTestInstrumentationScopeWrapper()), ms.Scope())
}

func TestScopeProfiles_Profiles(t *testing.T) {
	ms := NewScopeProfiles()
	assert.Equal(t, NewProfilesSlice(), ms.Profiles())
	ms.orig.Profiles = internal.GenTestProfilePtrSlice()
	assert.Equal(t, generateTestProfilesSlice(), ms.Profiles())
}

func TestScopeProfiles_SchemaUrl(t *testing.T) {
	ms := NewScopeProfiles()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newScopeProfiles(internal.NewScopeProfiles(), sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestScopeProfiles() ScopeProfiles {
	return newScopeProfiles(internal.GenTestScopeProfiles(), internal.NewState())
}
