// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestValueType_MoveTo(t *testing.T) {
	ms := generateTestValueType()
	dest := NewValueType()
	ms.MoveTo(dest)
	assert.Equal(t, NewValueType(), ms)
	assert.Equal(t, generateTestValueType(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestValueType(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newValueType(internal.NewValueType(), sharedState)) })
	assert.Panics(t, func() { newValueType(internal.NewValueType(), sharedState).MoveTo(dest) })
}

func TestValueType_CopyTo(t *testing.T) {
	ms := NewValueType()
	orig := NewValueType()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestValueType()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newValueType(internal.NewValueType(), sharedState)) })
}

func TestValueType_TypeStrindex(t *testing.T) {
	ms := NewValueType()
	assert.Equal(t, int32(0), ms.TypeStrindex())
	ms.SetTypeStrindex(int32(13))
	assert.Equal(t, int32(13), ms.TypeStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newValueType(internal.NewValueType(), sharedState).SetTypeStrindex(int32(13)) })
}

func TestValueType_UnitStrindex(t *testing.T) {
	ms := NewValueType()
	assert.Equal(t, int32(0), ms.UnitStrindex())
	ms.SetUnitStrindex(int32(13))
	assert.Equal(t, int32(13), ms.UnitStrindex())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newValueType(internal.NewValueType(), sharedState).SetUnitStrindex(int32(13)) })
}

func TestValueType_AggregationTemporality(t *testing.T) {
	ms := NewValueType()
	assert.Equal(t, AggregationTemporality(internal.AggregationTemporality(0)), ms.AggregationTemporality())
	testValAggregationTemporality := AggregationTemporality(internal.AggregationTemporality(1))
	ms.SetAggregationTemporality(testValAggregationTemporality)
	assert.Equal(t, testValAggregationTemporality, ms.AggregationTemporality())
}

func generateTestValueType() ValueType {
	return newValueType(internal.GenTestValueType(), internal.NewState())
}
